# Image Replacement Guide

## Overview
All images in this website can be easily replaced by simply updating the files in the `public/images/` folder. The website will automatically use the new images when you rebuild or reload.

## Image Folder Structure

```
public/images/
├── logo/
│   └── logo.svg (or logo.png)        # Main site logo (120x120px recommended)
├── hero/
│   └── hero-bg.jpg                   # Homepage hero background (1920x1080px)
├── about/
│   ├── team.jpg                      # Team/community photo (800x600px)
│   └── community.jpg                 # Community gathering (800x600px)
├── programs/
│   ├── leadership.jpg                # Leadership training (800x600px)
│   ├── youth.jpg                     # Youth empowerment (800x600px)
│   └── cultural.jpg                  # Cultural preservation (800x600px)
└── placeholder.svg                   # Default placeholder (DO NOT DELETE)
```

## How to Replace Images

### Step 1: Prepare Your Images
- Use high-quality images (JPG for photos, PNG for graphics with transparency, SVG for logos)
- Recommended dimensions are listed above
- Optimize images for web (keep file size under 500KB per image)
- Use descriptive, relevant images that match the content

### Step 2: Replace Files
1. Navigate to the `public/images/` folder in your project
2. Find the subfolder corresponding to the section (logo, hero, about, programs)
3. Replace the existing file with your new image
4. **IMPORTANT**: Keep the same filename OR update the reference in the code (see below)

### Step 3: Using Different Filenames
If you want to use different filenames, update the image paths in these files:
- Logo: `src/components/Header.tsx` (line ~50)
- Hero background: `src/components/Hero.tsx` (line ~20-25)
- About images: `src/pages/About.tsx`
- Program images: `src/pages/Programs.tsx`

### Step 4: Rebuild (if necessary)
- For development: Changes appear automatically
- For production: Run `npm run build` after replacing images

## Image Recommendations

### Logo (`logo/logo.svg` or `logo.png`)
- Square format (1:1 ratio)
- 120x120px minimum
- Transparent background (PNG) or SVG format
- Should work well on dark backgrounds

### Hero Background (`hero/hero-bg.jpg`)
- Wide landscape format (16:9 ratio)
- 1920x1080px or larger
- Dark or semi-dark image (text overlay will be white)
- Can use overlay effect for better text readability

### Section Images (about/, programs/)
- Landscape format (4:3 ratio recommended)
- 800x600px minimum
- Good lighting and clear subjects
- Relevant to the section content

## Free Stock Image Resources

If you need images, these sites offer free, high-quality photos:

1. **Unsplash** - https://unsplash.com
2. **Pexels** - https://pexels.com
3. **Pixabay** - https://pixabay.com

Search terms to try:
- "african traditional leaders"
- "community gathering"
- "cultural heritage"
- "leadership training"
- "youth empowerment"
- "traditional ceremony"

## Troubleshooting

**Image not showing:**
- Check the filename matches exactly (including extension)
- Ensure the file is in the correct folder
- Clear browser cache (Ctrl+Shift+R or Cmd+Shift+R)

**Image looks stretched/distorted:**
- Use recommended dimensions
- Check aspect ratio matches the space

**Image file too large:**
- Compress using tools like TinyPNG (https://tinypng.com)
- Recommended: Under 500KB per image

## Quick Reference

| Location | File | Recommended Size | Format |
|----------|------|------------------|--------|
| Logo | `logo/logo.svg` | 120x120px | SVG/PNG |
| Hero BG | `hero/hero-bg.jpg` | 1920x1080px | JPG |
| Team Photo | `about/team.jpg` | 800x600px | JPG |
| Community | `about/community.jpg` | 800x600px | JPG |
| Leadership | `programs/leadership.jpg` | 800x600px | JPG |
| Youth | `programs/youth.jpg` | 800x600px | JPG |
| Cultural | `programs/cultural.jpg` | 800x600px | JPG |
